<%@ Language=VBScript %>
<%
' 强制设置编码为UTF-8防止乱码
Response.CodePage = 65001
Response.Charset = "UTF-8"
Response.Buffer = True
Response.ContentType = "text/html; charset=UTF-8"

' 获取当前时间
Dim currentTime
currentTime = Now()

' 函数：安全地输出内容，确保UTF-8编码
Function SafeOutput(content)
    If IsNull(content) Or content = "" Then
        SafeOutput = ""
    Else
        SafeOutput = Server.HTMLEncode(content)
    End If
End Function
%>

<html>
<head>
<title>技术小学生网站 - ASP SMTP测试工具 - https://blog.tag.gg</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<style>
body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    margin: 0;
    padding: 0;
    background-color: #f5f7fa;
    color: #333;
    line-height: 1.6;
}
.container {
    max-width: 800px;
    margin: 20px auto;
    padding: 20px;
    background: white;
    border-radius: 8px;
    box-shadow: 0 0 20px rgba(0,0,0,0.1);
}
h1 {
    color: #2c3e50;
    text-align: center;
    margin-bottom: 5px;
}
.subtitle {
    text-align: center;
    color: #7f8c8d;
    margin-bottom: 20px;
    font-size: 16px;
}
h2 {
    color: #2c3e50;
    border-bottom: 2px solid #3498db;
    padding-bottom: 10px;
    margin-top: 0;
}
.alert {
    padding: 15px;
    margin-bottom: 20px;
    border-radius: 4px;
}
.alert-warning {
    background-color: #fff3cd;
    border-left: 5px solid #ffc107;
    color: #856404;
}
.form-group {
    margin-bottom: 15px;
}
.form-group label {
    display: block;
    margin-bottom: 5px;
    font-weight: 600;
}
.form-control {
    width: 100%;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
    box-sizing: border-box;
    font-size: 14px;
}
.form-control:focus {
    border-color: #3498db;
    outline: none;
    box-shadow: 0 0 5px rgba(52,152,219,0.3);
}
.btn {
    background-color: #3498db;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 4px;
    cursor: pointer;
    font-size: 16px;
    transition: background-color 0.3s;
}
.btn:hover {
    background-color: #2980b9;
}
.radio-group {
    display: flex;
    gap: 15px;
    margin: 10px 0;
}
.radio-option {
    display: flex;
    align-items: center;
}
.radio-option input {
    margin-right: 5px;
}
.result {
    margin-top: 20px;
    padding: 15px;
    border-radius: 4px;
}
.success {
    background-color: #d4edda;
    color: #155724;
    border-left: 5px solid #28a745;
}
.error {
    background-color: #f8d7da;
    color: #721c24;
    border-left: 5px solid #dc3545;
}
.loading {
    display: none;
    margin-top: 10px;
    color: #3498db;
    font-weight: bold;
}
.footer {
    margin-top: 30px;
    text-align: center;
    color: #7f8c8d;
    font-size: 14px;
}
.footer a {
    color: #3498db;
    text-decoration: none;
}
.footer a:hover {
    text-decoration: underline;
}
.select-smtp {
    width: 100%;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
    margin-bottom: 15px;
}
.password-hint {
    font-size: 12px;
    color: #7f8c8d;
    margin-top: 5px;
}
.smtp-custom-group {
    display: none;
}
</style>
<script>
function showLoading() {
    // 验证必填字段
    var requiredFields = ['fromEmail', 'toEmail', 'subject', 'body'];
    for (var i = 0; i < requiredFields.length; i++) {
        var field = document.getElementById(requiredFields[i]);
        if (field.value.trim() === '') {
            alert('请填写所有必填字段');
            field.focus();
            return false;
        }
    }
    
    // 获取SMTP服务器地址
    var smtpPreset = document.getElementById('smtpPreset');
    var smtpServer = document.getElementById('smtpServer');
    
    if (smtpPreset.value === 'custom') {
        // 自定义SMTP需要验证输入
        var customSmtp = document.getElementById('smtpCustomInput').value.trim();
        if (customSmtp === '') {
            alert('请输入自定义SMTP服务器地址');
            document.getElementById('smtpCustomInput').focus();
            return false;
        }
        smtpServer.value = customSmtp;
    } else {
        // 预设SMTP直接使用选择的值
        smtpServer.value = smtpPreset.value;
    }
    
    document.getElementById('loading').style.display = 'block';
    return true;
}

function selectSmtp(select) {
    var customSmtpGroup = document.getElementById('smtpCustomGroup');
    var smtpServerInput = document.getElementById('smtpServer');
    var smtpLabel = document.getElementById('smtpLabel');
    
    if (select.value === 'custom') {
        customSmtpGroup.style.display = 'block';
        smtpLabel.innerHTML = '自定义SMTP地址:';
        smtpServerInput.value = '';
    } else {
        customSmtpGroup.style.display = 'none';
        smtpLabel.innerHTML = 'SMTP服务器地址:';
        smtpServerInput.value = select.value;
    }
}

// 初始化页面时设置默认值
window.onload = function() {
    var select = document.getElementById('smtpPreset');
    var smtpServer = document.getElementById('smtpServer');
    
    // 设置默认值
    select.value = 'smtp.qq.com';
    smtpServer.value = 'smtp.qq.com';
    
    // 如果是从POST返回的页面，恢复之前的选择状态
    var postSmtp = '<%= SafeOutput(Request.Form("smtpServer")) %>';
    if (postSmtp && !select.querySelector('option[value="' + postSmtp + '"]')) {
        select.value = 'custom';
        document.getElementById('smtpCustomGroup').style.display = 'block';
        document.getElementById('smtpCustomInput').value = postSmtp;
    }
    
    selectSmtp(select);
};
</script>
</head>
<body>
<div class="container">
    <h1>技术小学生网站 - SMTP邮件发送测试工具</h1>
    <div class="subtitle">轻松测试您的SMTP服务器配置 - 当前时间: <%= SafeOutput(CStr(currentTime)) %></div>
    <div class="subtitle">技术小学生版权所有 - https://blog.tag.gg</div>

    <div class="alert alert-warning">
        <strong>安全提示:</strong> 测试完成后请删除此文件，防止被恶意利用！
    </div>

    <%
    ' 处理表单提交
    Dim resultMessage
    resultMessage = ""
    
    If Request.ServerVariables("REQUEST_METHOD") = "POST" Then
        ' 确保所有变量都声明
        Dim smtpServer, smtpPort, smtpUsername, smtpPassword, fromEmail, toEmail, subject, body
        Dim cdoMessage, cdoConfig, schema
        
        ' 获取表单数据并处理可能的空值
        smtpServer = Trim(Request.Form("smtpServer"))
        smtpPort = Request.Form("smtpPort")
        If smtpPort = "" Then smtpPort = "465"
        smtpUsername = Trim(Request.Form("smtpUsername"))
        smtpPassword = Trim(Request.Form("smtpPassword"))
        fromEmail = Trim(Request.Form("fromEmail"))
        toEmail = Trim(Request.Form("toEmail"))
        subject = Trim(Request.Form("subject"))
        body = Trim(Request.Form("body"))
        
        ' 验证必填字段
        If smtpServer = "" Or fromEmail = "" Or toEmail = "" Or subject = "" Or body = "" Then
            resultMessage = "<div class='result error'><strong>错误:</strong> 请填写所有必填字段</div>"
        Else
            On Error Resume Next
            
            ' 创建CDO对象
            Set cdoMessage = Server.CreateObject("CDO.Message")
            Set cdoConfig = Server.CreateObject("CDO.Configuration")
            
            ' 配置SMTP设置
            schema = "http://schemas.microsoft.com/cdo/configuration/"
            
            With cdoConfig.Fields
                .Item(schema & "sendusing") = 2 ' cdoSendUsingPort
                .Item(schema & "smtpserver") = smtpServer
                .Item(schema & "smtpserverport") = smtpPort
                If smtpUsername <> "" Then
                    .Item(schema & "smtpauthenticate") = 1 ' cdoBasic
                    .Item(schema & "sendusername") = smtpUsername
                    .Item(schema & "sendpassword") = smtpPassword
                End If
                .Item(schema & "smtpusessl") = (smtpPort = "465" Or smtpPort = "587")
                .Update
            End With
            
            ' 设置邮件内容
            With cdoMessage
                Set .Configuration = cdoConfig
                .From = fromEmail
                .To = toEmail
                .Subject = subject
                
                ' 使用HTMLBody并明确设置字符集为UTF-8
                Dim htmlBody
                htmlBody = "<html><head><meta http-equiv=""Content-Type"" content=""text/html; charset=UTF-8""></head><body>" & body & "</body></html>"
                .HTMLBody = htmlBody
                
                ' 同时设置TextBody以确保兼容性
                .TextBody = body
                
                ' 设置邮件头编码
                .BodyPart.Charset = "UTF-8"
                .Headers.Update "Content-Type", "text/html; charset=UTF-8"
                
                On Error Resume Next
                .Send
                If Err.Number <> 0 Then
                    resultMessage = "<div class='result error'><strong>errorr:</strong> " & SafeOutput(Err.Description) & "</div>"
                Else
                    resultMessage = "<div class='result success'><strong>Success!</strong> The test email has been sent to " & SafeOutput(toEmail) & "</div>"
                End If
                On Error GoTo 0
            End With
            
            ' 清理对象
            Set cdoMessage = Nothing
            Set cdoConfig = Nothing
            
            On Error GoTo 0
        End If
    End If
    
    ' 显示结果消息
    If resultMessage <> "" Then
        Response.Write resultMessage
    End If
    %>

    <form method="post" action="<%= Request.ServerVariables("SCRIPT_NAME") %>" onsubmit="return showLoading()">
        <input type="hidden" id="smtpServer" name="smtpServer" value="<%= SafeOutput(Request.Form("smtpServer")) %>">
        
        <div class="form-group">
            <label for="smtpPreset">常用SMTP服务器:</label>
            <select id="smtpPreset" class="select-smtp" onchange="selectSmtp(this)">
                <option value="smtp.qq.com">QQ邮箱 (smtp.qq.com)</option>
                <option value="smtp.163.com">163邮箱 (smtp.163.com)</option>
                <option value="smtp.aliyun.com">阿里云邮箱 (smtp.aliyun.com)</option>
                <option value="smtp.gmail.com">Gmail (smtp.gmail.com)</option>
                <option value="smtp.office365.com">Office365 (smtp.office365.com)</option>
                <option value="smtp.mail.yahoo.com">Yahoo邮箱 (smtp.mail.yahoo.com)</option>
                <option value="smtp.exmail.qq.com">腾讯企业邮箱 (smtp.exmail.qq.com)</option>
                <option value="custom">自定义SMTP服务器</option>
            </select>
        </div>
        
        <div class="form-group" id="smtpCustomGroup">
            <label id="smtpLabel">自定义SMTP地址:</label>
            <input type="text" id="smtpCustomInput" class="form-control" value="<%= SafeOutput(Request.Form("smtpServer")) %>" placeholder="例如: smtp.tag.gg">
        </div>
        
        <div class="form-group">
            <label>SMTP端口:</label>
            <div class="radio-group">
                <div class="radio-option">
                    <input type="radio" id="port25" name="smtpPort" value="25" <% If Request.Form("smtpPort") = "25" Then Response.Write "checked" End If %>>
                    <label for="port25">25 (非SSL)</label>
                </div>
                <div class="radio-option">
                    <input type="radio" id="port465" name="smtpPort" value="465" <% If Request.Form("smtpPort") = "465" Or Request.Form("smtpPort") = "" Then Response.Write "checked" End If %>>
                    <label for="port465">465 (SSL)</label>
                </div>
                <div class="radio-option">
                    <input type="radio" id="port587" name="smtpPort" value="587" <% If Request.Form("smtpPort") = "587" Then Response.Write "checked" End If %>>
                    <label for="port587">587 (TLS)</label>
                </div>
            </div>
        </div>
        
        <div class="form-group">
            <label for="smtpUsername">用户名:</label>
            <input type="text" id="smtpUsername" name="smtpUsername" class="form-control" value="<%= SafeOutput(Request.Form("smtpUsername")) %>" placeholder="通常是您的完整邮箱地址">
        </div>
        
        <div class="form-group">
            <label for="smtpPassword">密码/授权码:</label>
            <input type="password" id="smtpPassword" name="smtpPassword" class="form-control" value="<%= SafeOutput(Request.Form("smtpPassword")) %>" placeholder="部分邮箱需要使用授权码而非密码">
            <div class="password-hint">注意: QQ邮箱、163邮箱、阿里云邮箱等需要使用授权码</div>
        </div>
        
        <div class="form-group">
            <label for="fromEmail">发件人邮箱:</label>
            <input type="email" id="fromEmail" name="fromEmail" class="form-control" value="<%= SafeOutput(Request.Form("fromEmail")) %>" placeholder="例如: admin@tag.gg" required>
        </div>
        
        <div class="form-group">
            <label for="toEmail">收件人邮箱:</label>
            <input type="email" id="toEmail" name="toEmail" class="form-control" value="<%= SafeOutput(Request.Form("toEmail")) %>" placeholder="例如: admin@tag.gg" required>
        </div>
        
        <div class="form-group">
            <label for="subject">邮件主题:</label>
            <input type="text" id="subject" name="subject" class="form-control" value="<% If Request.Form("subject") = "" Then Response.Write "ASP-SMTP Mail Test - " & currentTime Else Response.Write SafeOutput(Request.Form("subject")) End If %>" required>
        </div>
        
        <div class="form-group">
            <label for="body">邮件内容:</label>
            <textarea id="body" name="body" class="form-control" rows="5" required><% 
                If Request.Form("body") = "" Then 
                    Response.Write "This is a test email sent from the ASP SMTP test tool. https://blog.tag.gg/"
                Else 
                    Response.Write SafeOutput(Request.Form("body")) 
                End If 
            %></textarea>
        </div>
        
        <button type="submit" class="btn">发送测试邮件</button>
        <div id="loading" class="loading">发送中，请稍候...</div>
    </form>
    
    <div class="footer">
        &copy; Tech Student 2025 | <a href="https://blog.tag.gg" target="_blank">blog.tag.gg</a>
    </div>
</div>
</body>
</html>